<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package mangosm
 */

get_header();
?>
    <div class="sy-body">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div id="primary" class="content-area sy-content-area">
                        <main id="main" class="site-main">

                        <?php
                        while ( have_posts() ) :
                            
                            if ( function_exists('comic_breadcrumbs') ) {
                                comic_breadcrumbs();
                            }

                            the_post();

                            get_template_part( 'template-parts/content', get_post_type() );

                            the_post_navigation( array(
                                'prev_text' => '<span class="screen-reader-text">Previous Chapter</span> ' .
                                    '<span class="post-title">%title</span>',
                                'next_text' => '<span class="screen-reader-text">Next Chapter</span> ' .
                                    '<span class="post-title">%title</span>',
                            ) );
                            
                            
                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() ) :
							comments_template();
							
                            endif;

                        endwhile; // End of the loop.
                        ?>

                        </main><!-- #main -->
                    </div><!-- #primary -->
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <?php get_sidebar(); ?>
                </div>
            </div>
        </div>
    </div>

<?php
get_footer();
