<?php
/**
 * The template for displaying single comic posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package mangosm
 */

get_header();
if (shortcode_exists('accessibility_button')) {
    echo do_shortcode('[accessibility_button]');
}
?>

<div class="sy-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 p-0 col-md-12 col-sm-12">
                <div id="primary" class="content-area sy-content-area">
                    <main id="main" class="site-main">


                        <?php

                        while (have_posts()):
                            the_post();


                            ?>

                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                <header class="entry-header px-3 px-lg-0">
                                    <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
                                </header><!-- .entry-header -->

                                <?php
                                // Get the current post URL and title
                                $post_url = urlencode(get_permalink());
                                $post_title = urlencode(get_the_title());
                                ?>



                                <div class="entry-content">

                                    <div class="socialts">
                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $post_url; ?>&amp;t=<?php echo $post_title; ?>"
                                            target="_blank" class="fb">
                                            <i class="icon-facebook"></i>
                                            <span>Facebook</span>
                                        </a>
                                        <a href="https://www.x.com/intent/tweet?url=<?php echo $post_url; ?>&amp;text=<?php echo $post_title; ?>"
                                            target="_blank" class="twt">
                                            <i class="icon-twitter"></i>
                                            <span>Twitter-X</span>
                                        </a>
                                        <a href="whatsapp://send?text=<?php echo $post_title; ?> <?php echo $post_url; ?>"
                                            target="_blank" class="wa">
                                            <i class="icon-whatsapp"></i>
                                            <span>WhatsApp</span>
                                        </a>
                                        <a href="https://pinterest.com/pin/create/button/?url=<?php echo $post_url; ?>&amp;media=&amp;description=<?php echo $post_title; ?>"
                                            target="_blank" class="pntrs">
                                            <i class="icon-pinterest-p"></i>
                                            <span>Pinterest</span>
                                        </a>
                                    </div>


                                    <?php
                                    // Display breadcrumbs
                                    if (function_exists('comic_breadcrumbs')) {
                                        comic_breadcrumbs();
                                    }
                                    ?>




                                    <?php
                                    function get_main_domain($url)
                                    {
                                        $parsed_url = parse_url($url);
                                        $host = isset($parsed_url['host']) ? $parsed_url['host'] : '';

                                        // Split the host into parts
                                        $host_parts = explode('.', $host);

                                        // Check if the host contains at least two parts (domain and TLD)
                                        if (count($host_parts) >= 2) {
                                            // Get the last two parts for the main domain (e.g., 'domain.com')
                                            $main_domain = implode('.', array_slice($host_parts, -2));
                                            return $main_domain;
                                        }

                                        return $host; // Return the full host if it's not in the expected format
                                    }

                                    $untouched_url = get_site_url();
                                    $main_domain = get_main_domain($untouched_url);

                                    echo "<p class='seo-paragraph  px-3 px-lg-0' style='text-align:center;'>" . get_the_title() . " - Read Free in English</p>";
                                    ?>



                                    <?php
                                    get_template_part('manga-header');

                                    ?>
                                    <div class="images-container">
                                        <?php
                                        the_content();
                                        ?>
                                    </div>
                                    <?php
                                    get_template_part('manga-header');
                                    ?>

                                    <p class="bottom-tags">
                                        <strong>tags</strong>: read manga <?php echo get_the_title(); ?>, comic
                                        <?php echo get_the_title(); ?> chapter,
                                        <?php echo get_the_title(); ?>, read <?php echo get_the_title(); ?> online,
                                        <?php echo get_the_title(); ?> manga scan,
                                        <?php echo get_the_title(); ?> chapter, <?php echo get_the_title(); ?> high quality,
                                        <?php echo esc_html(get_post_time('j F Y')); ?>
                                    </p>


                                </div><!-- .entry-content -->

                                <?php
                                if (shortcode_exists('manga_read_more')) {
                                    echo do_shortcode('[manga_read_more]');
                                }

                                if (shortcode_exists('mangosm_report_chapter_modal')) {
                                    echo do_shortcode('[mangosm_report_chapter_modal]');
                                }
                                ?>


                                <!-- Support Button -->
                                <div class="my-2 mx-auto d-flex flex-column align-items-center" style="gap: 10px;">
                                    <style>img.kofiimg{display: initial!important;vertical-align:middle;height:13px!important;width:20px!important;padding-top:0!important;padding-bottom:0!important;border:none;margin-top:0;margin-right:5px!important;margin-left:0!important;margin-bottom:3px!important;content:url('https://storage.ko-fi.com/cdn/cup-border.png')}.kofiimg:after{vertical-align:middle;height:25px;padding-top:0;padding-bottom:0;border:none;margin-top:0;margin-right:6px;margin-left:0;margin-bottom:4px!important;content:url('https://storage.ko-fi.com/cdn/whitelogo.svg')}.btn-container{display:inline-block!important;white-space:nowrap;min-width:160px}span.kofitext{color:#fff !important;letter-spacing: -0.15px!important;text-wrap:none;vertical-align:middle;line-height:33px !important;padding:0;text-align:center;text-decoration:none!important; text-shadow: 0 1px 1px rgba(34, 34, 34, 0.05);}.kofitext a{color:#fff !important;text-decoration:none:important;}.kofitext a:hover{color:#fff !important;text-decoration:none}a.kofi-button{box-shadow: 1px 1px 0px rgba(0, 0, 0, 0.2);line-height:36px!important;min-width:150px;display:inline-block!important;background-color:#29abe0;padding:2px 12px !important;text-align:center !important;border-radius:7px;color:#fff;cursor:pointer;overflow-wrap:break-word;vertical-align:middle;border:0 none #fff !important;font-family:'Quicksand',Helvetica,Century Gothic,sans-serif !important;text-decoration:none;text-shadow:none;font-weight:700!important;font-size:14px !important}a.kofi-button:visited{color:#fff !important;text-decoration:none !important}a.kofi-button:hover{opacity:.85;color:#f5f5f5 !important;text-decoration:none !important}a.kofi-button:active{color:#f5f5f5 !important;text-decoration:none !important}.kofitext img.kofiimg {height:15px!important;width:22px!important;display: initial;animation: kofi-wiggle 3s infinite;}@keyframes kofi-wiggle{0%{transform:rotate(0) scale(1)}60%{transform:rotate(0) scale(1)}75%{transform:rotate(0) scale(1.12)}80%{transform:rotate(0) scale(1.1)}84%{transform:rotate(-10deg) scale(1.1)}88%{transform:rotate(10deg) scale(1.1)}92%{transform:rotate(-10deg) scale(1.1)}96%{transform:rotate(10deg) scale(1.1)}100%{transform:rotate(0) scale(1)}}</style>
                                    
                                    <a title="Support me on ko-fi.com" class="kofi-button" style="width:fit-content;background-color:#0074b3;" href="https://ko-fi.com/N4N6G1S5B" target="_blank"> <span class="kofitext"><img src="https://storage.ko-fi.com/cdn/cup-border.png" alt="Ko-fi donations" class="kofiimg">I work hard to offer this manga for free</span></a>
                                    <a title="Support me on ko-fi.com" class="kofi-button" style="width:fit-content;background-color:#67519F;" href="https://ko-fi.com/N4N6G1S5B" target="_blank"> <span class="kofitext"><img src="https://storage.ko-fi.com/cdn/cup-border.png" alt="Ko-fi donations" class="kofiimg">Your donation would mean a lot to me!</span></a>
                                    <a title="Support me on ko-fi.com" class="kofi-button" style="width:fit-content;background-color:#C05A9A;" href="https://ko-fi.com/N4N6G1S5B" target="_blank"> <span class="kofitext"><img src="https://storage.ko-fi.com/cdn/cup-border.png" alt="Ko-fi donations" class="kofiimg">Buy Me Coffee ❤</span></a>
                                    <a title="Support me on ko-fi.com" class="kofi-button" style="width:fit-content;background-color:#F66E7B;" href="https://ko-fi.com/N4N6G1S5B" target="_blank"> <span class="kofitext"><img src="https://storage.ko-fi.com/cdn/cup-border.png" alt="Ko-fi donations" class="kofiimg">Donate Now ❤</span></a>
                                </div>

                                
                            </article><!-- #post-<?php the_ID(); ?> -->

                        <?php endwhile; // End of the loop. ?>

                    </main><!-- #main -->
                </div><!-- #primary -->
            </div><!-- .col -->

            <div class="col-lg-12 col-md-12 col-sm-12">
                <?php get_sidebar(); ?>
            </div><!-- .col -->
        </div><!-- .row -->
    </div><!-- .container -->
</div><!-- .sy-body -->

<?php
get_footer();
