<?php
/**
 * The template for displaying single comic posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package mangosm
 */

get_header();

?>

<div class="sy-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 p-0 col-md-12 col-sm-12">
                <div id="primary" class="content-area sy-content-area">
                    <main id="main" class="site-main">


                        <?php

                        while (have_posts()):

                            the_post();


                            ?>


                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>


                                <?php
                                $post_id = get_the_ID();
                                $nicknames_string = get_post_meta(get_the_ID(), '_character_nicknames', true);
                                $description = get_post_meta(get_the_ID(), '_character_description', true);
                                $character_id = get_post_meta(get_the_ID(), '_character_id', true);

                                $image_id = get_post_meta(get_the_ID(), '_character_image_id', true);

                                if (!empty($image_id) && wp_attachment_is_image($image_id)) {
                                    $image = wp_get_attachment_image_src($image_id, 'full');
                                    $image_url = $image[0];
                                } else {
                                    $image_url = get_template_directory_uri() . '/assets/images/character_placeholder.webp'; // fallback image
                                }



                                ?>


                                <div class="entry-content">
                                    <div class="row m-0">



                                        <!-- info section -->
                                        <div class="col-md-8 col-lg-9 col-sm-12 w-full info-section" >
                                            <header class="entry-header">
                                                <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
                                            </header><!-- .entry-header -->

                                            <img class="d-block d-md-none mx-auto character-image" alt="<?= the_title() ?> image" src="<?php echo $image_url;?>">

                                            
                                            <?php
                                                if (!empty($nicknames_string)) {

                                                    echo '<p class="mb-0 text-white">Nicknames:</p>';
                                                    // Convert string to array by exploding, and trim whitespace from each genre
                                                    $nicknames = array_map('trim', explode(',', $nicknames_string));
            
                                                    // Output the list of genres
                                                    if (!empty($nicknames)) {
                                                        echo '<div class="nickname-list">';
                                                        foreach ($nicknames as $nickname) {
                                                            // Ensure the genre is not empty after trimming
                                                            if (!empty($nickname)) {
                                                                echo '<span class="nickname-list-item">' . esc_html($nickname) . '</span>';
                                                            }
                                                        }
                                                        echo '</div>';
                                                    }
                                                }
                                            ?>

                                            <div class="my-5 text-white description"><?= wpautop($description)?></div>
                                        </div>

                                        <!-- image section -->
                                        <div class="col-md-4 col-lg-3 col-sm-12 w-full d-none d-md-flex justify-content-end">
                                           
                                            <img class="character-image" style="position: sticky; top: 50px;" alt="<?= the_title() ?> image" src="<?php echo $image_url;?>">
                                            
                                        </div>

                                    </div>


                                </div><!-- .entry-content -->


                                <hr>
                                <?php if(!empty($character_id)){ ?>
                                <p class="powered-by">Powered By: <a target="_blank" href="https://jikan.moe/" >Jikan Api</a> / <a target="_blank" href="https://myanimelist.net/character/<?= $character_id?>" >MyAnimeList</a></p>
                                
                                <?php } ?>


                                 <!-- Support Button -->
                                 <div class="my-2 mx-auto d-flex justify-content-center">
                                    <style>
                                        img.kofiimg {
                                            display: initial !important;
                                            vertical-align: middle;
                                            height: 13px !important;
                                            width: 20px !important;
                                            padding-top: 0 !important;
                                            padding-bottom: 0 !important;
                                            border: none;
                                            margin-top: 0;
                                            margin-right: 5px !important;
                                            margin-left: 0 !important;
                                            margin-bottom: 3px !important;
                                            content: url('https://storage.ko-fi.com/cdn/cup-border.png')
                                        }

                                        .kofiimg:after {
                                            vertical-align: middle;
                                            height: 25px;
                                            padding-top: 0;
                                            padding-bottom: 0;
                                            border: none;
                                            margin-top: 0;
                                            margin-right: 6px;
                                            margin-left: 0;
                                            margin-bottom: 4px !important;
                                            content: url('https://storage.ko-fi.com/cdn/whitelogo.svg')
                                        }

                                        .btn-container {
                                            display: inline-block !important;
                                            white-space: nowrap;
                                            min-width: 160px
                                        }

                                        span.kofitext {
                                            color: #fff !important;
                                            letter-spacing: -0.15px !important;
                                            text-wrap: none;
                                            vertical-align: middle;
                                            line-height: 33px !important;
                                            padding: 0;
                                            text-align: center;
                                            text-decoration: none !important;
                                            text-shadow: 0 1px 1px rgba(34, 34, 34, 0.05);
                                        }

                                        .kofitext a {
                                            color: #fff !important;
                                            text-decoration: none:important;
                                        }

                                        .kofitext a:hover {
                                            color: #fff !important;
                                            text-decoration: none
                                        }

                                        a.kofi-button {
                                            box-shadow: 1px 1px 0px rgba(0, 0, 0, 0.2);
                                            line-height: 36px !important;
                                            min-width: 150px;
                                            display: inline-block !important;
                                            background-color: #29abe0;
                                            padding: 2px 12px !important;
                                            text-align: center !important;
                                            border-radius: 7px;
                                            color: #fff;
                                            cursor: pointer;
                                            overflow-wrap: break-word;
                                            vertical-align: middle;
                                            border: 0 none #fff !important;
                                            font-family: 'Quicksand', Helvetica, Century Gothic, sans-serif !important;
                                            text-decoration: none;
                                            text-shadow: none;
                                            font-weight: 700 !important;
                                            font-size: 14px !important
                                        }

                                        a.kofi-button:visited {
                                            color: #fff !important;
                                            text-decoration: none !important
                                        }

                                        a.kofi-button:hover {
                                            opacity: .85;
                                            color: #f5f5f5 !important;
                                            text-decoration: none !important
                                        }

                                        a.kofi-button:active {
                                            color: #f5f5f5 !important;
                                            text-decoration: none !important
                                        }

                                        .kofitext img.kofiimg {
                                            height: 15px !important;
                                            width: 22px !important;
                                            display: initial;
                                            animation: kofi-wiggle 3s infinite;
                                        }

                                        @keyframes kofi-wiggle {
                                            0% {
                                                transform: rotate(0) scale(1)
                                            }

                                            60% {
                                                transform: rotate(0) scale(1)
                                            }

                                            75% {
                                                transform: rotate(0) scale(1.12)
                                            }

                                            80% {
                                                transform: rotate(0) scale(1.1)
                                            }

                                            84% {
                                                transform: rotate(-10deg) scale(1.1)
                                            }

                                            88% {
                                                transform: rotate(10deg) scale(1.1)
                                            }

                                            92% {
                                                transform: rotate(-10deg) scale(1.1)
                                            }

                                            96% {
                                                transform: rotate(10deg) scale(1.1)
                                            }

                                            100% {
                                                transform: rotate(0) scale(1)
                                            }
                                        }
                                    </style>
                                    <a title="Support me on ko-fi.com" class="kofi-button" style="background-color:#0074b3;"
                                        href="https://ko-fi.com/H2H8R3AE1" target="_blank"> <span class="kofitext"><img
                                                src="https://storage.ko-fi.com/cdn/cup-border.png" alt="Ko-fi donations"
                                                class="kofiimg">Support US</span></a>



                                </div>

                                
                            </article><!-- #post-<?php the_ID(); ?> -->

                        <?php endwhile; // End of the loop. ?>

                    </main><!-- #main -->
                </div><!-- #primary -->
            </div><!-- .col -->

            <div class="col-lg-12 col-md-12 col-sm-12">
                <?php get_sidebar(); ?>
            </div><!-- .col -->
        </div><!-- .row -->
    </div><!-- .container -->
</div><!-- .sy-body -->

<?php
get_footer();
