<?php
/**
 * mangosm Theme Customizer
 *
 * @package mangosm
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function mangosm_customize_register($wp_customize)
{
    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport = 'postMessage';
    $wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

    if (isset($wp_customize->selective_refresh)) {
        $wp_customize->selective_refresh->add_partial('blogname', [
            'selector' => '.site-title a',
            'render_callback' => 'mangosm_customize_partial_blogname',
        ]);
        $wp_customize->selective_refresh->add_partial('blogdescription', [
            'selector' => '.site-description',
            'render_callback' => 'mangosm_customize_partial_blogdescription',
        ]);
    }

    /* $wp_customize->add_section('mangosm_homepage_sidebar_section', [
        'priority' => 5,
        'title' => esc_html__('Homepage Sidebar', 'mangosm')
    ]);
    $wp_customize->add_setting('mangosm_homepage_sidebar', [
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'mangosm_checkbox_sanitize'
    ]);
    $wp_customize->add_control('mangosm_homepage_sidebar', [
        'type' => 'checkbox',
        'label' => esc_html__('Homepage Sidebar', 'mangosm'),
        'settings' => 'mangosm_homepage_sidebar',
        'section' => 'mangosm_homepage_sidebar_section'
    ]); */


    /* $wp_customize->add_section('mangosm_top_nav_section', [
        'priority' => 1,
        'title' => esc_html__('Header', 'mangosm'),
    ]);

    $wp_customize->add_setting('mangosm_search_checkbox', [
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'mangosm_checkbox_sanitize'
    ]);
    $wp_customize->add_control('mangosm_search_checkbox', [
        'type' => 'checkbox',
        'label' => esc_html__('Enable Search', 'mangosm'),
        'settings' => 'mangosm_search_checkbox',
        'section' => 'mangosm_top_nav_section',
    ]);

    $wp_customize->add_setting('mangosm_social_link_checkbox', [
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'mangosm_checkbox_sanitize'
    ]);
    $wp_customize->add_control('mangosm_social_link_checkbox', [
        'type' => 'checkbox',
        'label' => esc_html__('Enable Social Link', 'mangosm'),
        'settings' => 'mangosm_social_link_checkbox',
        'section' => 'mangosm_top_nav_section',
    ]);
    $wp_customize->add_setting('mangosm_facebook_link', [
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ]);
    $wp_customize->add_control('mangosm_facebook_link', [
        'settings' => 'mangosm_facebook_link',
        'section' => 'mangosm_top_nav_section',
        'type' => 'url',
        'label' => esc_html__('Facebook Url', 'mangosm')
    ]);
    $wp_customize->add_setting('mangosm_twitter_link', [
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ]);
    $wp_customize->add_control('mangosm_twitter_link', [
        'settings' => 'mangosm_twitter_link',
        'section' => 'mangosm_top_nav_section',
        'type' => 'url',
        'label' => esc_html__('Twitter Url', 'mangosm')
    ]);
    $wp_customize->add_setting('mangosm_instagram_link', [
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ]);
    $wp_customize->add_control('mangosm_instagram_link', [
        'settings' => 'mangosm_instagram_link',
        'section' => 'mangosm_top_nav_section',
        'type' => 'url',
        'label' => esc_html__('Instagram Url', 'mangosm')
    ]);

    $wp_customize->add_setting('mangosm_youtube_link', [
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ]);
    $wp_customize->add_control('mangosm_youtube_link', [
        'settings' => 'mangosm_youtube_link',
        'section' => 'mangosm_top_nav_section',
        'type' => 'url',
        'label' => esc_html__('Youtube Url', 'mangosm')
    ]); */

    //sanitize checkbox function
    function mangosm_checkbox_sanitize($input)
    {
        if ($input == 1) {
            return 1;
        } else {
            return '';
        }
    }
}
add_action('customize_register', 'mangosm_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function mangosm_customize_partial_blogname()
{
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function mangosm_customize_partial_blogdescription()
{
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function mangosm_customize_preview_js()
{
    wp_enqueue_script('mangosm-customizer', get_template_directory_uri() . '/js/customizer.js', ['customize-preview'], '20151215', true);
}
add_action('customize_preview_init', 'mangosm_customize_preview_js');
