<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package mangosm
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">


    <?php wp_head(); ?>
</head>

<body id="sy-body" <?php body_class(); ?>>
    <?php
    if (function_exists('wp_body_open')) {
        wp_body_open();
    }
    ?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'mangosm'); ?></a>


        <header id="masthead" class="site-header sy-header">
            <div id="tsparticles"></div>

            <div class="container-fluid" style="max-width:930px;">
                <div class="row align-items-center">
                    

                    <div class="col-lg-12 col-1 ">
                        <div class="d-flex align-items-center justify-content-center">
                            <div id="main-nav" class="nnc-nav">
                                <nav id="site-navigation" class="main-navigation">
                                    <div id="close-menu" class="sy-close-menu d-lg-none mb-4 l-h-0" title="close">
                                        <svg class="sy-icon sy-icon--md">
                                            <use xlink:href="#sy-icon-close"></use>
                                        </svg>
                                    </div>
                                    <ul id="primary-menu" class="menu">
                                        <li><a href="<?php echo esc_url(home_url('/')); ?>">Home Page</a>
                                        </li>

                                        <?php
                                        // Query to get the first comic post
                                        $args_first = array(
                                            'post_type' => 'comic',
                                            'orderby' => 'menu_order',
                                            'posts_per_page' => 1,
                                            'order' => 'ASC',
                                        );
                                        $first_comic = new WP_Query($args_first);

                                        // Query to get the last comic post
                                        $args_last = array(
                                            'post_type' => 'comic',
                                            'orderby' => 'menu_order',
                                            'posts_per_page' => 1,
                                            'order' => 'DESC',
                                        );
                                        $last_comic = new WP_Query($args_last);

                                        // Check if there are any comic posts
                                        $count_comics = wp_count_posts('comic')->publish;

                                        // Output menu items based on the number of comic posts
                                        if ($count_comics > 0) {
                                            // Display the first comic post
                                            if ($first_comic->have_posts()):
                                                $first_comic->the_post();
                                                ?>
                                                <li><a href="<?php the_permalink(); ?>"
                                                        aria-label="<?php echo the_title() ?>"><?php echo esc_html(extract_chapter_title(get_the_title())); ?></a>
                                                </li>
                                                <?php
                                                wp_reset_postdata();
                                            endif;

                                            // Display the last comic post, only if there is more than one comic post
                                            if ($count_comics > 1 && $last_comic->have_posts()):
                                                $last_comic->the_post();
                                                ?>
                                                <li><a href="<?php the_permalink(); ?>"
                                                        aria-label="<?php echo the_title() ?>"><?php echo esc_html(extract_chapter_title(get_the_title())); ?></a>
                                                </li>
                                                <?php
                                                wp_reset_postdata();
                                            endif;
                                        }

                                        if (is_plugin_active('mangosm-characters-support/mangosm-characters-support.php')):
                                            ?>
                                            <li><a
                                                    href="<?php echo esc_url(home_url('/characters')); ?>"><?php esc_html_e('Characters', 'mangosm'); ?></a>
                                            <?php endif; ?>


                                    </ul>
                                </nav><!-- #site-navigation -->
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 col-md-12 col-12 mt-3 mt-lg-0">
                        <div class="d-flex justify-content-end">

                            <button id="mobile-menu" aria-label="toggle nav list"
                                class="sy-mobile-menu d-lg-none d-block l-h-0  m-0">
                                <svg class="sy-icon sy-icon--primary sy-icon--lg">
                                    <use xlink:href="#sy-icon-menu"></use>
                                </svg>
                            </button>

                        </div>
                    </div>
                </div>
            </div>
        </header><!-- #masthead -->
        
        <div id="content" class="site-content">