<?php
/*
 * Template Name: Characters Template
 * Description: Custom template for the manga characters page
 */

get_header();
?>

<div class="sy-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 p-0 col-md-12 col-sm-12">
                <div id="primary" class="content-area sy-content-area">
                    <main id="main" class="site-main">
                        <header class="entry-header px-3 px-lg-0">
                            <h1 class="entry-title text-center">CHARACTERS</h1>
                        </header>

                        <hr>

                        <div class="d-flex flex-wrap justify-content-center character-list">
                            <?php
                            $character_query = new WP_Query([
                                'post_type' => 'character', // or your custom post type (e.g. 'character'?)
                                'posts_per_page' => -1, // Show all
                            ]);

                            if ($character_query->have_posts()):
                                while ($character_query->have_posts()):
                                    $character_query->the_post();
                                    $image_id = get_post_meta(get_the_ID(), '_character_image_id', true);
                                    $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'medium') : get_template_directory_uri() . '/assets/images/character_placeholder.webp';
                                    ?>

                                    <a href="<?php the_permalink(); ?>" class="character-card">
                                        <img loading="lazy" src="<?php echo esc_url($image_url); ?>"
                                            alt="<?php the_title(); ?> image">
                                        <p class="character-name"><?php the_title(); ?></p>
                                    </a>

                                    <?php
                                endwhile;
                                wp_reset_postdata();
                            else:
                                echo '<p>No characters found.</p>';
                            endif;
                            ?>
                        </div>




                    </main><!-- #main -->
                </div><!-- #primary -->
            </div><!-- .col -->

            <div class="col-lg-12 col-md-12 col-sm-12">
                <?php get_sidebar(); ?>
            </div><!-- .col -->
        </div><!-- .row -->
    </div><!-- .container -->
</div><!-- .sy-body -->

<?php
get_footer();
