<?php
/*
Plugin Name: Report Chapter (requires contact form 7) For Mangosm Theme
Description: Generates a "Report Chapter" section with a contact form for reporting issues in chapters.
Version: 1.0
Author: osmZ
Requires Plugins: contact-form-7
*/

function mangosm_report_chapter_button_shortcode(){
    ob_start();
    ?>
        <button type="button" aria-label="open report chapter modal" class="mx-2 chapter-report-modal-btn">
        <i class="icon-bug"></i>
</button>
    
    <?php
    return ob_get_clean();
};

add_shortcode('mangosm_report_chapter_button', 'mangosm_report_chapter_button_shortcode');

function mangosm_report_chapter_modal_shortcode(){
    ob_start();
    ?>

    <div id="report-chapter-backdrop" class="report-chapter-backdrop d-none"></div>

    <div class="report-chapter-modal flex-column px-3 py-2 d-none">
        <div class="report-chapter-modal-header d-flex justify-content-between text-white text-lg" >
            <p class="p-0 m-0 font-weight-bold">Report Chapter:</p>
            <button type="button" id="chapter-report-modal-x-btn"  class="btn w-fit p-2 h-fit p-0 text-white" aria-label="close report modal">x</button>
        </div>

    <?php
    
    if (shortcode_exists('contact-form-7')) {
        echo do_shortcode('[contact-form-7 id="a2c8774" title="Report Chapter"]');
    }else{
        echo '<p class="error">Contact Form 7 plugin is not installed or the form ID is incorrect.</p>';
    }
    ?>
    </div>
    
    
    <?php
    return ob_get_clean();
};

add_shortcode('mangosm_report_chapter_modal', 'mangosm_report_chapter_modal_shortcode');



/* Enqeuque js script */

function mangosm_report_chapter_enqueue_scripts() {
    if (is_singular('comic')) {
        wp_enqueue_script(
            'mangosm_report_chapter',
            plugin_dir_url(__FILE__) . 'js/mangosm_report_chapter.js',
            [],
            null,
            true
        );
    }
}
add_action('wp_enqueue_scripts', 'mangosm_report_chapter_enqueue_scripts');

function mangosm_report_chapter_enqueue_styles() {
    if (is_singular('comic')) {
        wp_enqueue_style(
            'mangosm_report_chapter-style',
            plugin_dir_url(__FILE__) . 'css/style.css',
            [],
            null,
            false
            
        );
    }
}
add_action('wp_enqueue_scripts', 'mangosm_report_chapter_enqueue_styles');


function dequeue_cf7_styles() {
    if (function_exists('wpcf7_enqueue_styles')) {
        wp_dequeue_style('contact-form-7');  // Dequeue Contact Form 7 CSS
        wp_deregister_style('contact-form-7'); // Optional: deregister it too
    }
}
add_action('wp_enqueue_scripts', 'dequeue_cf7_styles', 20);
