document.addEventListener('DOMContentLoaded', function () {

    const modalBtn = document.querySelectorAll('.chapter-report-modal-btn');
    const modalCloseBtn = document.querySelector('#chapter-report-modal-x-btn');
    const modal = document.querySelector('.report-chapter-modal');
    const backdrop = document.querySelector('.report-chapter-backdrop');
    const backdropClickArea = document.querySelector('#report-chapter-backdrop');

    function toggleModal() {
        modal.classList.toggle('d-none');
        modal.classList.toggle('d-flex');
        backdrop.classList.toggle('d-none');
        backdrop.classList.toggle('d-flex');
    }

    modalBtn.forEach(element => {
        element.addEventListener('click', toggleModal);
    });
    
    if (modalCloseBtn) modalCloseBtn.addEventListener('click', toggleModal);
    if (backdropClickArea) backdropClickArea.addEventListener('click', toggleModal);

    // Set the post title in the input field
    const postTitleElement = document.querySelector('.entry-title');
    const postTitle = postTitleElement ? postTitleElement.textContent.trim() : '';
    const postTitleInput = document.querySelector('#post-title');
    if (postTitleInput) postTitleInput.value = postTitle;

    // Set the current URL in the input field
    const pageUrlInput = document.querySelector('#page-url');
    if (pageUrlInput) pageUrlInput.value = window.location.href;

});
