document.addEventListener('DOMContentLoaded', function () {

    const deleteButtons = document.querySelectorAll('.delete-manga');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault();

            console.log("delete clicked");

            const index = this.getAttribute('data-index');

            fetch(mangaReadMore.ajax_url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'manga_read_more_delete',
                    index: index,
                }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Option 1: Reload the page
                    location.reload();

                    // Option 2: Remove the manga card without reload:
                    // this.closest('.manga-card').remove();
                } else {
                    alert('Error deleting manga');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Request failed');
            });
        });
    });

});
